//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop


#include "ListList_OOP_BCB_V6U.h"
#include "SingleEntry.h"
#include <mmsystem.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
        RootDir = NULL;
        Randomize(); 
}

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
   if (RootDir) delete RootDir;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ShowEntry(const String S)
{
  ListBox1->Items->Add(S);
}

// Ausgabe der Demo-Liste (100 Elemente)
void __fastcall TForm1::PrintListList(BSingleEntry* List, int Level)
{ String Lead = "";
  BSingleEntry* E;

  for (int x = 1; x < Level; x++)
	  Lead = Lead + "  ";
  // EntryName+' (LIST) fr Verzeichnisse
  ShowEntry(Lead + List->GetDisplayName());

  // Dateieintrge und Verzeichnisse, ungeordnet
  for (int x = 0; ; x++)
  {
	  E = List->GetEntry(x);
	  if (!E) break;
	  PrintListList(E, Level+1);
  }
}


// Listenaufbau (rekursiv)
void __fastcall TForm1::BuildListList(BSingleEntry* List, int Level)
{ int LocalCount, NameLength;
  String NewName;

  // maximal 25 Eintrge pro Liste - nur das Stammverzeichnis
  // kann mehr haben
  LocalCount = rand() % 25  + 1;

  for (int x = 1; x <= LocalCount; x++)
  {
	EntryCount--;
	// zuflliger Name mit 1-8 Zeichen
    NameLength = rand() % 8 + 1;
    NewName = "";
    for (int y = 1; y <= NameLength; y++)
		NewName = NewName + char((int)'a' + (rand() % 26));

    // Einzelner Eintrag oder neue Liste? Die Wahrscheinlichkeit
    // fr neue Listen (und weitere Rekursion) sinkt mit zunehmender
    // Verschachelungstiefe
    if (rand() % (10*Level) < 1)
        BuildListList(List->AddNode(NewName), Level+1); // new list
      else List->AddEntry(NewName);

    if (EntryCount == 0)
		break;
  }
}

void __fastcall TForm1::ClearList()
{
  if (RootDir) delete RootDir;
  RootDir = NULL;
}

// Legt die Elementenzahl fest und erzeugt das Stammverzeichnis
void __fastcall TForm1::BuildBaseList(int ECount)
{
  if (RootDir == NULL) RootDir = new BListEntry("C:");
  EntryCount = ECount;
  // irgendein Startwert fr rand()
  srand((unsigned)time(NULL));

  while (EntryCount > 0)
	BuildListList(RootDir,1);
}


void __fastcall TForm1::bCreateTreeClick(TObject *Sender)
{
  ListBox1->Clear();
  ClearList();
  BuildBaseList(100);
  PrintListList(RootDir, 1);
  ClearList();
}
//---------------------------------------------------------------------------

String TForm1::FindListEntry(BListEntry* List, const String SubStr)
{ BSingleEntry* Result = List->FindEntry(SubStr);

  if (Result != NULL) return Result->FullName();
	else return "";
}



// 1 Million Objekte, 24 Millionen Suchvorgnge
void __fastcall TForm1::bBenchCreateClick(TObject *Sender)
{
	ListBox1->Clear(); ListBox1->Update();
	DWORD fullBench;
	DWORD constructionTime = 0;
	DWORD destructionTime = 0;
	DWORD findTime = 0;
	DWORD meanTime;

  ClearList();
  fullBench = timeGetTime();
  for (int x = 1; x <= 10; x++)
  {
	meanTime = timeGetTime();
	BuildBaseList(100000);             // Konstruktion
	constructionTime += (timeGetTime() - meanTime);
	meanTime = timeGetTime();
	// Suchen
    ShowEntry("Search a: " + FindListEntry(RootDir, "a"));
    ShowEntry("Search ax: " + FindListEntry(RootDir, "ax"));
    ShowEntry("Search axv: " + FindListEntry(RootDir, "axv"));
    ShowEntry("Search axve: " + FindListEntry(RootDir, "axve"));

    for (int y = 1; y <= 20; y++)
      FindListEntry(RootDir,"X"); // gibts nicht
	findTime += (timeGetTime() - meanTime);
    ListBox1->Update();

	meanTime = timeGetTime();
	ClearList();                       // Destruktion
	destructionTime += (timeGetTime() - meanTime);
  }

	String Msg;
	Msg += (String("Time:\t\t") + DWORDToTime(timeGetTime()-fullBench));
	Msg += (String("\nfor Construction:\t") + DWORDToTime(constructionTime));
	Msg += (String("\nfor Destruction:\t") + DWORDToTime(destructionTime));
	Msg += (String("\nfor Find:\t\t") + DWORDToTime(findTime));
	ShowMessage(Msg);
}

String TForm1::DWORDToTime(DWORD Millisecs)
{
	DWORD std, min, sec, ms;
	std = Millisecs / 3600000;
	min = Millisecs % 3600000 / 60000;
	sec = Millisecs % 60000 / 1000;
	ms = Millisecs % 1000;
	String s;
	s.printf("%.2d:%.2d:%.2d.%.3d", std, min, sec, ms);

	return s;
}

